/*
 * Decompiled with CFR 0.152.
 */
package com.hoshino.cti.mixin;

import com.hoshino.cti.content.environmentSystem.EnvironmentalHandler;
import com.hoshino.cti.content.environmentSystem.IEnvironmentalSource;
import com.hoshino.cti.mixin.LivingEntityAccessor;
import com.hoshino.cti.mixin.TIMixin.ServerPlayerAccessor;
import com.hoshino.cti.register.CtiEffects;
import com.hoshino.cti.util.ILivingEntityMixin;
import com.hoshino.cti.util.StrictDamageProcess;
import com.mojang.logging.LogUtils;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatKillPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.scores.Score;
import net.minecraft.world.scores.Team;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import net.minecraftforge.common.ForgeHooks;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
implements ILivingEntityMixin {
    @Unique
    private static final Logger cti$LOGGER = LogUtils.getLogger();
    @Unique
    public boolean cti$shouldCancelKnockBack = false;

    @Shadow
    public abstract boolean m_21023_(MobEffect var1);

    @Shadow
    @Nullable
    public abstract LivingEntity m_21188_();

    @Inject(at={@At(value="HEAD")}, method={"checkTotemDeathProtection"}, cancellable=true)
    private void checkTotemDeathProtection(DamageSource pDamageSource, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity living = (LivingEntity)this;
        if (pDamageSource.m_19379_() || pDamageSource.m_7639_() == living) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"aiStep"}, cancellable=true)
    public void StopAi(CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        if (entity.getPersistentData().m_128451_("emp") > 0) {
            entity.getPersistentData().m_128405_("emp", entity.getPersistentData().m_128451_("emp") - 1);
            if (entity.getPersistentData().m_128451_("emp") <= 0) {
                entity.getPersistentData().m_128473_("emp");
            }
            ci.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    public void CtiTick(CallbackInfo callbackInfo) {
        Player player;
        LivingEntity entity = (LivingEntity)this;
        Level level = entity.f_19853_;
        if (entity instanceof Player && ((player = (Player)entity).m_7500_() || player.m_5833_())) {
            return;
        }
        if (!(entity instanceof Player) && entity != null && entity.getPersistentData().m_128471_("vulnerable")) {
            entity.f_19802_ = 0;
        }
        if (!level.f_46443_ && level.m_46467_() % 10L == 0L) {
            EnvironmentalHandler.livingTick(entity);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    public void FreezeTick(CallbackInfo callbackInfo) {
        LivingEntity entity = (LivingEntity)this;
        Level level = entity.f_19853_;
        if (!level.f_46443_ && (double)EnvironmentalHandler.getFrozenResistance(entity) > 0.5 && entity instanceof Player) {
            entity.m_146924_(false);
            entity.m_146917_(-10);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"hurt"}, cancellable=true)
    public void Hurt(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (this.m_21023_((MobEffect)CtiEffects.ev.get())) {
            cir.setReturnValue((Object)false);
        } else if (source instanceof IEnvironmentalSource) {
            cir.setReturnValue((Object)EnvironmentalHandler.hurtEntity((LivingEntity)this, source, amount));
        }
    }

    @Override
    @Unique
    public void cti$actuallyHurt(DamageSource pDamageSource, float pDamageAmount) {
        LivingEntity living = (LivingEntity)this;
        pDamageAmount = StrictDamageProcess.getStrictDamageForEntity(living, pDamageAmount);
        ForgeHooks.onLivingHurt((LivingEntity)living, (DamageSource)pDamageSource, (float)pDamageAmount);
        if (pDamageAmount > 0.0f && pDamageAmount < 3.4028235E37f && pDamageSource.m_7639_() instanceof ServerPlayer) {
            ((ServerPlayer)pDamageSource.m_7639_()).m_6278_(Stats.f_12988_.m_12902_((Object)Stats.f_12929_), Math.round(pDamageAmount * 10.0f));
        }
        ForgeHooks.onLivingDamage((LivingEntity)living, (DamageSource)pDamageSource, (float)pDamageAmount);
        float f1 = living.m_21223_();
        living.m_21231_().m_19289_(pDamageSource, f1, pDamageAmount);
        living.m_21153_(f1 - pDamageAmount);
        living.m_146850_(GameEvent.f_223706_);
    }

    @Override
    @Unique
    public boolean cti$strictHurt(DamageSource pSource, float pAmount) {
        LivingEntity living = (LivingEntity)this;
        LivingEntityAccessor accessor = (LivingEntityAccessor)living;
        ForgeHooks.onLivingAttack((LivingEntity)living, (DamageSource)pSource, (float)pAmount);
        if (living.f_19853_.f_46443_) {
            return false;
        }
        if (living.m_21224_()) {
            return false;
        }
        if (living.m_5803_() && !living.f_19853_.f_46443_) {
            living.m_5796_();
        }
        accessor.setNoActionTime(0);
        float f = pAmount;
        boolean flag = false;
        float f1 = 0.0f;
        living.f_20924_ = 1.5f;
        boolean flag1 = true;
        if ((float)living.f_19802_ > 10.0f) {
            if (pAmount <= accessor.getLastHurt()) {
                return false;
            }
            this.cti$actuallyHurt(pSource, pAmount - accessor.getLastHurt());
            accessor.setLastHurt(pAmount);
            flag1 = false;
        } else {
            accessor.setLastHurt(pAmount);
            living.f_19802_ = 20;
            this.cti$actuallyHurt(pSource, pAmount);
            living.f_20916_ = living.f_20917_ = 10;
        }
        if (pSource.m_146705_() && !living.m_6844_(EquipmentSlot.HEAD).m_41619_()) {
            accessor.hurtHelmet(pSource, pAmount);
            pAmount *= 0.75f;
        }
        living.f_20918_ = 0.0f;
        Entity entity1 = pSource.m_7639_();
        if (entity1 != null) {
            TamableAnimal tamableEntity;
            if (entity1 instanceof LivingEntity && !pSource.m_181121_()) {
                living.m_6703_((LivingEntity)entity1);
            }
            if (entity1 instanceof Player) {
                accessor.setLastHurtByPlayerTime(100);
                living.m_6598_((Player)entity1);
            } else if (entity1 instanceof TamableAnimal && (tamableEntity = (TamableAnimal)entity1).m_21824_()) {
                accessor.setLastHurtByPlayerTime(100);
                LivingEntity livingentity = tamableEntity.m_21826_();
                if (livingentity != null && livingentity.m_6095_() == EntityType.f_20532_) {
                    living.m_6598_((Player)livingentity);
                } else {
                    living.m_6598_(null);
                }
            }
        }
        if (flag1) {
            if (pSource instanceof EntityDamageSource && ((EntityDamageSource)pSource).m_19403_()) {
                living.f_19853_.m_7605_((Entity)living, (byte)33);
            } else {
                int b0 = pSource == DamageSource.f_19312_ ? 36 : (pSource.m_19384_() ? 37 : (pSource == DamageSource.f_19325_ ? 44 : (pSource == DamageSource.f_146701_ ? 57 : 2)));
                living.f_19853_.m_7605_((Entity)living, (byte)b0);
            }
            if (pSource != DamageSource.f_19312_) {
                accessor.markHurt();
            }
            if (entity1 != null) {
                double d1 = entity1.m_20185_() - living.m_20185_();
                double d0 = entity1.m_20189_() - living.m_20189_();
                while (d1 * d1 + d0 * d0 < 1.0E-4) {
                    d1 = (Math.random() - Math.random()) * 0.01;
                    d0 = (Math.random() - Math.random()) * 0.01;
                }
                living.f_20918_ = (float)(Mth.m_14136_((double)d0, (double)d1) * 57.2957763671875 - (double)living.m_146908_());
                living.m_147240_((double)0.4f, d1, d0);
            } else {
                living.f_20918_ = (int)(Math.random() * 2.0) * 180;
            }
        }
        if (living.m_21224_()) {
            SoundEvent soundevent = accessor.getDeathSound();
            if (flag1 && soundevent != null) {
                living.m_5496_(soundevent, accessor.getSoundVolume(), living.m_6100_());
            }
            this.cti$strictDie(pSource);
        } else if (flag1) {
            accessor.playHurtSound(pSource);
        }
        accessor.setLastDamageSource(pSource);
        accessor.setLastDamageStamp(living.f_19853_.m_46467_());
        if (living instanceof ServerPlayer) {
            CriteriaTriggers.f_10574_.m_35174_((ServerPlayer)living, pSource, f, pAmount, flag);
        }
        if (entity1 instanceof ServerPlayer) {
            CriteriaTriggers.f_10573_.m_60112_((ServerPlayer)entity1, (Entity)living, pSource, f, pAmount, flag);
        }
        return true;
    }

    @Override
    @Unique
    public void cti$strictDie(DamageSource pDamageSource) {
        LivingEntity living = (LivingEntity)this;
        LivingEntityAccessor accessor = (LivingEntityAccessor)living;
        if (living instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)living;
            ServerPlayerAccessor playerAccessor = (ServerPlayerAccessor)player;
            living.m_146850_(GameEvent.f_223707_);
            boolean flag = player.f_19853_.m_46469_().m_46207_(GameRules.f_46142_);
            if (flag) {
                Component component = player.m_21231_().m_19293_();
                player.f_8906_.m_243119_((Packet)new ClientboundPlayerCombatKillPacket(player.m_21231_(), component), PacketSendListener.m_243073_(() -> {
                    int i = 256;
                    String s = component.m_130668_(256);
                    MutableComponent component1 = Component.m_237110_((String)"death.attack.message_too_long", (Object[])new Object[]{Component.m_237113_((String)s).m_130940_(ChatFormatting.YELLOW)});
                    MutableComponent component2 = Component.m_237110_((String)"death.attack.even_more_magic", (Object[])new Object[]{player.m_5446_()}).m_130938_(arg_0 -> LivingEntityMixin.lambda$cti$strictDie$0((Component)component1, arg_0));
                    return new ClientboundPlayerCombatKillPacket(player.m_21231_(), (Component)component2);
                }));
                Team team = player.m_5647_();
                if (team != null && team.m_7468_() != Team.Visibility.ALWAYS) {
                    if (team.m_7468_() == Team.Visibility.HIDE_FOR_OTHER_TEAMS) {
                        player.f_8924_.m_6846_().m_215621_((Player)player, component);
                    } else if (team.m_7468_() == Team.Visibility.HIDE_FOR_OWN_TEAM) {
                        player.f_8924_.m_6846_().m_215649_((Player)player, component);
                    }
                } else {
                    player.f_8924_.m_6846_().m_240416_(component, false);
                }
            } else {
                player.f_8906_.m_9829_((Packet)new ClientboundPlayerCombatKillPacket(player.m_21231_(), CommonComponents.f_237098_));
            }
            playerAccessor.removeEntitiesOnShoulder();
            if (player.f_19853_.m_46469_().m_46207_(GameRules.f_46126_)) {
                playerAccessor.tellNeutralMobsThatIDied();
            }
            if (!player.m_5833_()) {
                accessor.dropAllDeathLoot(pDamageSource);
            }
            player.m_36329_().m_83427_(ObjectiveCriteria.f_83590_, player.m_6302_(), Score::m_83392_);
            LivingEntity livingentity = player.m_21232_();
            if (livingentity != null) {
                player.m_36246_(Stats.f_12987_.m_12902_((Object)livingentity.m_6095_()));
                livingentity.m_5993_((Entity)player, accessor.getDeathScore(), pDamageSource);
                accessor.createWitherRose(livingentity);
            }
            player.f_19853_.m_7605_((Entity)player, (byte)3);
            player.m_36220_(Stats.f_12935_);
            player.m_7166_(Stats.f_12988_.m_12902_((Object)Stats.f_12991_));
            player.m_7166_(Stats.f_12988_.m_12902_((Object)Stats.f_12992_));
            player.m_20095_();
            player.m_146917_(0);
            player.m_146868_(false);
            player.m_21231_().m_19296_();
            player.m_219749_(Optional.of(GlobalPos.m_122643_((ResourceKey)player.f_19853_.m_46472_(), (BlockPos)player.m_20183_())));
        } else {
            living.m_21153_(0.0f);
            if (!living.m_213877_() && !accessor.getDead()) {
                Entity entity = pDamageSource.m_7639_();
                LivingEntity livingentity = living.m_21232_();
                if (accessor.getDeathScore() >= 0 && livingentity != null) {
                    livingentity.m_5993_((Entity)living, accessor.getDeathScore(), pDamageSource);
                }
                if (living.m_5803_()) {
                    living.m_5796_();
                }
                if (!living.f_19853_.f_46443_ && living.m_8077_()) {
                    cti$LOGGER.info("Named entity {} died: {}", (Object)living, (Object)living.m_21231_().m_19293_().getString());
                }
                accessor.setDead(true);
                living.m_21231_().m_19296_();
                if (living.f_19853_ instanceof ServerLevel) {
                    if (entity == null || entity.m_214076_((ServerLevel)living.f_19853_, living)) {
                        living.m_146850_(GameEvent.f_223707_);
                        accessor.dropAllDeathLoot(pDamageSource);
                        accessor.createWitherRose(livingentity);
                    }
                    living.f_19853_.m_7605_((Entity)living, (byte)3);
                }
                living.m_20124_(Pose.DYING);
            }
            if (living instanceof Player) {
                Player player = (Player)living;
                accessor.reapplyPosition();
                if (!player.m_5833_()) {
                    accessor.dropAllDeathLoot(pDamageSource);
                }
                if (pDamageSource != null) {
                    player.m_20334_((double)(-Mth.m_14089_((float)((player.f_20918_ + player.m_146908_()) * ((float)Math.PI / 180))) * 0.1f), (double)0.1f, (double)(-Mth.m_14031_((float)((player.f_20918_ + player.m_146908_()) * ((float)Math.PI / 180))) * 0.1f));
                } else {
                    player.m_20334_(0.0, 0.1, 0.0);
                }
                player.m_36220_(Stats.f_12935_);
                player.m_7166_(Stats.f_12988_.m_12902_((Object)Stats.f_12991_));
                player.m_7166_(Stats.f_12988_.m_12902_((Object)Stats.f_12992_));
                player.m_20095_();
                player.m_146868_(false);
                player.m_219749_(Optional.of(GlobalPos.m_122643_((ResourceKey)player.f_19853_.m_46472_(), (BlockPos)player.m_20183_())));
            }
        }
    }

    @Inject(method={"hurt"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;knockback(DDD)V")})
    private void set(DamageSource pSource, float pAmount, CallbackInfoReturnable<Boolean> cir) {
        if (pSource.m_19387_()) {
            this.cti$shouldCancelKnockBack = true;
        }
    }

    @Inject(method={"knockback"}, at={@At(value="HEAD")}, cancellable=true)
    private void knock(double pStrength, double pX, double pZ, CallbackInfo ci) {
        if (this.cti$shouldCancelKnockBack) {
            this.cti$shouldCancelKnockBack = false;
            ci.cancel();
        }
    }

    private static /* synthetic */ Style lambda$cti$strictDie$0(Component component1, Style p_143420_) {
        return p_143420_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)component1));
    }
}

